(function () {

    'use strict';

    angular.module('translation', ['pascalprecht.translate', 'ngCookies'])
        .config(['$translateProvider', '$httpProvider', function ($translateProvider, $httpProvider) {

            $translateProvider
                .useSanitizeValueStrategy('escape')
                .useStaticFilesLoader({
                    prefix: 'translations/translation-',
                    suffix: '.json'
                })
                .registerAvailableLanguageKeys(['en', 'de', 'pl'], {
                    'en*': 'en',
                    'de*': 'de',
                    'pl*': 'pl'
                })
                .fallbackLanguage('en')
                .determinePreferredLanguage()

            }
        ]
    )

})();
